/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

public class Text extends Scrollable {

//TODO Just temporary
public static final String DELIMITER = " | ";

public Text (Composite parent, int style) {
	super (parent, checkStyle (style));
}

public void addModifyListener (ModifyListener listener) {
}

public void addSelectionListener (SelectionListener listener) {
}

public void addVerifyListener (VerifyListener listener) {
}

public void append (String string) {
	setText(getText()+"<br>"+string);
}

static int checkStyle (int style) {
	if ((style & SWT.SEARCH) != 0) {
		style |= SWT.SINGLE | SWT.BORDER;
		style &= ~SWT.PASSWORD;
	}
	if ((style & SWT.SINGLE) != 0 && (style & SWT.MULTI) != 0) {
		style &= ~SWT.MULTI;
	}
	style = checkBits (style, SWT.LEFT, SWT.CENTER, SWT.RIGHT, 0, 0, 0);
	if ((style & SWT.SINGLE) != 0) style &= ~(SWT.H_SCROLL | SWT.V_SCROLL | SWT.WRAP);
	if ((style & SWT.WRAP) != 0) {
		style |= SWT.MULTI;
		style &= ~SWT.H_SCROLL;
	}
	if ((style & SWT.MULTI) != 0) style &= ~SWT.PASSWORD;
	if ((style & (SWT.SINGLE | SWT.MULTI)) != 0) return style;
	if ((style & (SWT.H_SCROLL | SWT.V_SCROLL)) != 0) return style | SWT.MULTI;
	return style | SWT.SINGLE;
}

public void clearSelection () {
}

public void copy () {
}

public void cut () {
}

public int getBorderWidth () {
	return 0;
}

public int getCaretLineNumber () {
	return 0;
}

public Point getCaretLocation () {
	return null;
}

public int getCaretPosition () {
	return 0;
}

public int getCharCount () {
	return 0;
}

public boolean getDoubleClickEnabled () {
	return false;
}

public char getEchoChar () {
	return 0;
}

public boolean getEditable () {
	return false;
}

public int getLineCount () {
	return 0;
}

public String getLineDelimiter () {
	return "";
}

public int getLineHeight () {
	return 0;
}

public int getOrientation () {
	return 0;
}

public String getMessage () {
	return "";
}

public Point getSelection () {
	return null;
}

public int getSelectionCount () {
	return 0;
}

public String getSelectionText () {
	return "";
}

public int getTabs () {
	return 0;
}

public String getText () {
	return _getText ();
}

public String getText (int start, int end) {
	return "";
}

public int getTextLimit () {
	return 0;
}

public int getTopIndex () {
	return 0;
}

public int getTopPixel () {
	return 0;
}

public void insert (String string) {
}

public void paste () {
}

public void removeModifyListener (ModifyListener listener) {
}

public void removeSelectionListener (SelectionListener listener) {
}

public void removeVerifyListener (VerifyListener listener) {
}

public void selectAll () {
}

public void setDoubleClickEnabled (boolean doubleClick) {
}

public void setEchoChar (char echo) {
}

public void setEditable (boolean editable) {
}

public void setFont (Font font) {
}

public void setMessage (String message) {
}

public void setOrientation (int orientation) {
}

public void setSelection (int start) {
}

public void setSelection (int start, int end) {
}

public void setRedraw (boolean redraw) {
}

public void setSelection (Point selection) {
}

public void setTabs (int tabs) {
}

public void setText (String string) {
	_setText(string);
}

public void setTextLimit (int limit) {
}

public void setTopIndex (int index) {
}

public void showSelection () {	
}

/*--------------------- NATIVE INTERFACE ------------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.TextMulti"]){
		$wnd.dojo._hasResource["org.eclipse.swt.TextMulti"] = true;
		$wnd.dojo.provide("org.eclipse.swt.TextMulti");
		
		$wnd.dojo.require("dijit._editor.RichText");
	
		$wnd.dojo.declare("org.eclipse.swt.TextMulti", $wnd.dijit._editor.RichText, {
//TODO find out how to initialize the size not manually
//			inheritWidth: true,
 			border: "1px solid #BFBFBF",
			height: "150px",
			textAlign: "left",
			width: "300px",
			_open: function(args){
				if (args || args.domNode) {
					args.domNode.style.display = "";
				}
				this.open();
			},
			_updateSize: function(){
				try {
					this.scrollbarNode = $wnd.dojo.isIE ? this.iframe.contentWindow.document.body : this.iframe;
					if (!this.scrollbarNode) {throw "Text iframe not loaded yet";}
					$wnd.swt.setCssStyle(this.scrollbarNode, {
						overflowX: this.domNode.style.overflowX=="scroll" ? "scroll" : "hidden",
						overflowY: this.domNode.style.overflowY=="scroll" ? "scroll" : "hidden"
					});
					$wnd.swt.setCssStyle(this.domNode, {overflowX: "hidden", overflowY: "hidden"});
				} catch(e) {
					var connection = $wnd.dojo.connect(this,"onLoad",function(){
						this._updateSize();
						$wnd.dojo.disconnect(connection);
					});
				}
			},
			destroy: function(){
				this.inherited("destroy", arguments);
				if(this.bgIframe){
					this.bgIframe.destroy();
					delete this.bgIframe;
				}
				if(this.domNode){
					$wnd.dojo._destroyElement(this.domNode);
					delete this.domNode;
				}
				if(this.srcNodeRef){
					$wnd.dojo._destroyElement(this.srcNodeRef);
					delete this.srcNodeRef;
				}
			},
//TODO get the size of the container of the text, when longer/higher than the default size of the text box 			
			getNativeBounds: function(){
				var dim = {};
				if (this.iframe) {
					var ifSize = $wnd.swt.getNativeSize(this.iframe);
					var dnLoc = $wnd.swt.getNativeLocation(this.domNode);
					var dnPadBorderExtends = $wnd.dojo._getPadBorderExtents(this.domNode);
					dim = {t: dnLoc.t, l: dnLoc.l, w: ifSize.w + dnPadBorderExtends.w, h: ifSize.h + dnPadBorderExtends.h};
				} else {
					dim = $wnd.swt.getNativeBounds(this.domNode);
				}
				return dim;
			},
			open: function(){
				try {
//FIXME try/catch in IE doesn't throw if not connected to body, so temporary manual check			
					if ($wnd.dojo.isIE && !$wnd.swt.isConectedToBody(this.domNode)) {throw "Text iframe not initialized yet"} 
					this.inherited("open",arguments);
					this._updateSize();
				} catch(e) { 
//					$wnd.console.log(e);
				}
			},
			postCreate: function(){
				$wnd.dojo.publish("org.eclipse.swt.TextMulti::init", [this]);
				$wnd.dojo.subscribe("org.eclipse.swt.TabItem::setControl", this, "_open");
				$wnd.swt.setCssStyle(this.domNode, {border: this.border});
				this.setupDefaultShortcuts();
				this.setAlignment(this.textAlign);
			},
			resize: function(dim){},
			setAlignment: function(alignment){
				try {
					if (this.isLoaded) {
						$wnd.swt.setCssStyle(this.iframe.contentWindow.document.body, {textAlign: alignment});
					} else {
						throw "Text iframe not loaded yet";
					}
				} catch(e) {
					var connection = $wnd.dojo.connect(this,"onLoad",function(){
						this.setAlignment(alignment);
						$wnd.dojo.disconnect(connection);
					});
				}
			},
			setValue: function(string){
				try {
					if (this.isLoaded) {
						this.inherited("setValue",arguments);
					} else {
						throw "Text iframe not loaded yet";
					}
				} catch(e) {
					var connection = $wnd.dojo.connect(this,"onLoad",function(){
						this.setValue(string);
						$wnd.dojo.disconnect(connection);
					});
				}
			},
			setWidgetBounds: function(dim){
				var dnDim = $wnd.swt.setBounds(this.domNode, dim);
				if (this.iframe) {
					try {
						if ($wnd.dojo.isIE) {
							var iframeBody = this.iframe.contentWindow.document.body;
							if (!iframeBody) {throw "Text iframe not loaded yet";}
							$wnd.swt.setNativeBounds(this.iframe, {h:dnDim.h, w:dnDim});
							$wnd.swt.setNativeBounds(iframeBody, {h:dnDim.h, w:dnDim});
							$wnd.swt.setCssStyle(iframeBody.firstChild, {
								height: iframeBody.clientHeight+"px",
								width: iframeBody.clientWidth+"px"
							});
						} else {
							$wnd.swt.setNativeBounds(this.iframe, {h:dnDim.h, w:dnDim});
							$wnd.swt.setCssStyle(this.iframe.contentDocument.body.parentNode, {height: "auto"});
							$wnd.swt.setCssStyle(this.iframe.contentDocument.body, {height: "auto"});
						}
					} catch (e) {
						var connection = $wnd.dojo.connect(this,"onLoad",function(){
							this.setWidgetBounds(dim);
							$wnd.dojo.disconnect(connection);
						});
					}
				}
			}
		});
	}
	if(!$wnd.dojo._hasResource["org.eclipse.swt.TextSingle"]){
		$wnd.dojo._hasResource["org.eclipse.swt.TextSingle"] = true;
		$wnd.dojo.provide("org.eclipse.swt.TextSingle");
		
		$wnd.dojo.require("dijit.form.TextBox");
	
		$wnd.dojo.declare("org.eclipse.swt.TextSingle", $wnd.dijit.form.TextBox, {
			border: "1px solid #BFBFBF",
			readOnly: false,
			textAlign: "left",
			postCreate: function(){
				this.inherited("postCreate",arguments);
				$wnd.swt.setCssStyle(this.domNode, {border: this.border});
				$wnd.swt.setCssStyle(this.textbox, {textAlign: this.textAlign});
				this.textbox.readonly = this.readOnly;
			},
			resize: function(dim){},
			setWidgetBounds: function(dim){
				$wnd.swt.setBounds(this.domNode, dim);
			}
		});
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var params = {};
	if((style & (@org.eclipse.swt.SWT::BORDER)) != 0){
		params.border = "1px solid black";
	}
	if((style & (@org.eclipse.swt.SWT::READ_ONLY)) != 0){
		params.readOnly = true;
	}
	if((style & (@org.eclipse.swt.SWT::LEFT)) != 0) {
		params.textAlign = "left";
	}
	else if((style & (@org.eclipse.swt.SWT::CENTER)) != 0) {
		params.textAlign = "center";
	}
	else if((style & (@org.eclipse.swt.SWT::RIGHT)) != 0) {
		params.textAlign = "right";
	}
	if((style & (@org.eclipse.swt.SWT::MULTI)) != 0) {
		var self = new $wnd.org.eclipse.swt.TextMulti(params);
	} else if((style & (@org.eclipse.swt.SWT::SINGLE)) != 0) {
		var self = new $wnd.org.eclipse.swt.TextSingle(params);
	}
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
		if (self.open) {self.open()};
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

public native String _getText () /*-{
	return this.@org.eclipse.swt.widgets.Widget::jsObject.getValue();
}-*/;

public native void _setText (String string) /*-{
	this.@org.eclipse.swt.widgets.Widget::jsObject.setValue(string);
}-*/;

}
